--//////////////////////////////////////////////////////////////////////////////////////////////////////
/*


Create/set project struture  macro

	by pfbreton, David Cunningham, 2006, 3ds max 9
	
	1.	User invokes the Set Project Folder command.
	2.	He his provided with a Browse for Folder dialog and selects a folder.
	3.  The current Path Configuration are backup'ed in the current working folder
	4.	The working directory is changed to the selected directory.
	5.	If the folder contains a *.mxp file, the first *.mxp file is loaded.
	6.	If not, a warning message is displayed

*/
--//////////////////////////////////////////////////////////////////////////////////////////////////////
macroScript SetProjectFolder
	category:~SETPROJECTFOLDER_CATEGORY~ 			-- LOC Notes: Localize this 
	internalCategory:"Tools" 
	tooltip:~SETPROJECTFOLDER_TOOLTIP~				-- LOC Notes: Localize this 
	ButtonText:~SETPROJECTFOLDER_BUTTONTEXT~ 			-- LOC Notes: Localize this 
	iconName: "MainUI/SetActiveProject" --LOC_NOTES: do not localize this
(
	-- following 2 variables must be global. They are set by the c++ code that implements pathConfig.doProjectSetupStepsUsingDirectory
	global _SetProjectFolder_macro_option_promptUser
	global _SetProjectFolder_macro_option_newFolder
	On Execute Do	
	(
		--------------------------------
		--Browse for folder dialog
		--------------------------------
		local strMyFolder= ""
		local strCurrProjectFolder = pathconfig.getCurrentProjectFolder()
		if( _SetProjectFolder_macro_option_promptUser == undefined  or  -- the value hasn't been defined, default to prompt user
			_SetProjectFolder_macro_option_promptUser == true) then
		(
			strMyFolder = getSavePath caption:~SETPROJECTFOLDER_CAPTION~ \
								 initialDir:(strCurrProjectFolder) -- LOC Notes: Localize this 
		)
		else
		(
			-- we use the global value set from within the app
			strMyFolder = _SetProjectFolder_macro_option_newFolder
		)
		-- always default to prompt the user
		_SetProjectFolder_macro_option_promptUser = true

		--user selected a valid folder
		if (strMyFolder != undefined) and (strMyFolder != "") then  
		(		
			-----------------------------------------------
			--does a selected folder contains *.mxp files?
			-----------------------------------------------
			doesFolderExist = doesFileExist strMyFolder allowDirectory:true
			if(doesFolderExist and pathconfig.IsProjectFolder(strMyFolder)) then 
			(
				-----------------------------------------------
				-- backup the current config paths settings in the current working folder 
				-- to not lose possible modifications that might have been done
				-- before switching the working folder
				-----------------------------------------------
				pathconfig.SaveTo(pathconfig.getCurrentProjectFolderPath())

				pathconfig.setCurrentProjectFolder strMyFolder
			
				arStrFnames = getfiles (strMyFolder + "\\*.mxp") -- LOC Notes: Do Not Localize this 
			
				--Warns the user about the fact that the folder contains 
				--more than one *.mxp file: assumes that the first found is used.
				if (arStrFnames.count != 1) then
				(
					if (GetQuietMode() == false) then
					(
						messagebox (~FOLDER_CONTAINS_MORE_THAN_ONE_CONFIG_FILE_CAPTION~ + arStrFnames[1] + ~WILL_BE_USED_TO_DETERMINE_YOUR_PATHS_CONFIGURATION_CAPTION~) title:~SET_PROJECT_FOLDER_TITLE~ beep:false -- LOC Notes: Localize this 
					)
				)
				
				--loads the MXP file
				pathconfig.load(arStrFnames[1])
			)
			else
			(
				------------------------------------------------------------------
				--No MXP file exists.
				------------------------------------------------------------------
				if (GetQuietMode() == false) then
				(		
					messagebox (~FOLDER_DOES_NOT_CONTAIN_PROJECT~) title:~FOLDER_NAME_INVALID_TITLE~ beep:false -- LOC Notes: Localize this 
				)
			)
		) 
		else if (strMyFolder == "") then
		(
			--user selected an invalide folder
			if (GetQuietMode() == false) then
			(			
				messagebox (~FOLDER_NAME_IS_INVALID_CAPTION~) title:~FOLDER_NAME_IS_INVALID_TITLE~ beep:false -- LOC Notes: Localize this 
			)
		)
		-- user canceled, do nothing.	
	)
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBOUGlIObvHrVvwm3cheq1jmkQTYUiVZrT4
-- ijAsK4JxR7es/0p+pV/5MWhv9zBaSZ9G22WFmxb0N5FdIhbBtvu0tg//+xJKx92O
-- 2EpAuF5LuXuGku39nSHkvKVf48McT0O9J3afGeu+QASbUtOHfryhWb/RFTDQfTlk
-- SHR/FZjJ2KT+8e2q3LW0p52CMDiLIfbI/nqy/9GHoofC6Y3vghxYDtC+ehKJrkJ5
-- VnKyVQMP4OZtq+qViS8nBy35PusUGhvRCz0EpjPoj/P1LJ4ojVh9xmUW6e2Img1B
-- mlVhFSUsYK4MHX2RT5rTNPMx86cMtV4b59Lm39lXsIHazC477dJ7
-- -----END-SIGNATURE-----